import QtQuick 2.2
import QtQuick.Window 2.2
import Qt.labs.settings 1.0

import AdaptDemoSystem 1.0


Demo {
    id: demo
//    Timer {
//        interval: 10
//        running: true
//        repeat: true
//        onTriggered: {
//            rocket.update();
//        }
//    }


    Rocket {
        id: rocket
    }



    onWindowWidthChanged: {
        console.log("wpw:"+windowWidth)
    }

    onWindowPosXChanged: {
        console.log("wpx:"+windowPosX)
    }

    Settings {
        property alias windowPosX: demo.windowPosX
        property alias windowPosY: demo.windowPosY
    }

    function getSavePointX2D(name) {
        var a = demo.savePointX2D(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointY2D(name) {
        var a = demo.savePointY2D(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointZ2D(name) {
        var a = demo.savePointZ2D(name);
        var b = rocket.syncUpdate;
        return a;
    }

    function getSavePointX(name) {
        var a = demo.savePointX(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointY(name) {
        var a = demo.savePointY(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointZ(name) {
        var a = demo.savePointZ(name);
        var b = rocket.syncUpdate;
        return a;
    }

    function getSavePointCX(name) {
        var a = demo.savePointCX(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointCY(name) {
        var a = demo.savePointCY(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointCZ(name) {
        var a = demo.savePointCZ(name);
        var b = rocket.syncUpdate;
        return a;
    }

    property int g_uid: 0

    function getUniqueId() {
        g_uid++;
        return g_uid;
    }

    function syncRocketRoot(track) {
        var a = rocket.sync(track);
        var b = rocket.syncUpdate;
      //  console.log("syncRocketRoot, track:"+track+" value:"+a)
        return a;
      //  return 0.0;
    }

    function modValue(propertyName, propertyValue) {
        demo.modifySkeneValue(editorLoader.sceneName, propertyName, "", propertyValue);
    }

    function demoTime() {
        return rocket.time;
    }
    function time() {
        return rocket.time;
    }

    function markUpdateFrequent() {
        rocket.markUpdateFrequent();
    }

    Component.onCompleted: {
        demo.reloadDemo();
    }
}

